"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setConfig = setConfig;
const tslib_1 = require("tslib");
const node_readline_1 = tslib_1.__importDefault(require("node:readline"));
const env_1 = require("../../../../util/env");
/* v8 ignore start */
async function setConfig(config) {
    const env = (0, env_1.getEnv)();
    if (env.CODESPACES !== 'true') {
        return config;
    }
    if (!config.token && env.GITHUB_TOKEN) {
        config.token = env.GITHUB_TOKEN;
    }
    if (!config.repositories?.length) {
        const rl = node_readline_1.default.promises.createInterface({
            input: process.stdin,
            output: process.stdout,
        });
        const repo = await rl.question('\n\nRepository name: ');
        config.repositories = [repo];
    }
    return config;
}
/* v8 ignore stop */
//# sourceMappingURL=codespaces.js.map