import type { CreateNodeOptions, Document, DocumentOptions, ParseOptions, SchemaOptions, ToStringOptions } from 'yaml';
import type { ZodType } from 'zod';
export interface YamlOptions<ResT = unknown, Schema extends ZodType<ResT> = ZodType<ResT>> extends ParseOptions, DocumentOptions, SchemaOptions {
    customSchema?: Schema;
    removeTemplates?: boolean;
}
interface YamlParseDocumentOptions extends ParseOptions, DocumentOptions, SchemaOptions {
    removeTemplates?: boolean;
}
export interface YamlOptionsMultiple<ResT = unknown, Schema extends ZodType<ResT> = ZodType<ResT>> extends YamlOptions<ResT, Schema> {
    failureBehaviour?: 'throw' | 'filter';
}
export type DumpOptions = DocumentOptions & SchemaOptions & ParseOptions & CreateNodeOptions & ToStringOptions;
/**
 * Parse a YAML string into a JavaScript object.
 *
 * Multiple documents are supported.
 *
 * If a schema is provided, the parsed object will be validated against it.
 *
 * If failureBehaviour is set to 'filter',
 *      the function will return an empty array if the YAML parsing or schema validation fails and therefore will not throw an error.
 *
 * If failureBehaviour is set to 'throw',
 *      the function will throw an error if the YAML parsing or schema validation fails for ANY document.
 * @param content
 * @param options
 */
export declare function parseYaml<ResT = unknown>(content: string, options?: YamlOptionsMultiple<ResT>): ResT[];
/**
 * Parse a YAML string into a JavaScript object.
 *
 * Only a single document is supported.
 *
 * If a schema is provided, the parsed object will be validated against it.
 * Should the YAML parsing or schemata validation fail, an error will be thrown.
 *
 * @param content
 * @param options
 */
export declare function parseSingleYaml<ResT = unknown>(content: string, options?: YamlOptions<ResT>): ResT;
/**
 * Parse a YAML string into a Document representation.
 *
 * Only a single document is supported.
 *
 * @param content
 * @param options
 */
export declare function parseSingleYamlDocument(content: string, options?: YamlParseDocumentOptions): Document;
export declare function dump(obj: any, opts?: DumpOptions): string;
export {};
