"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getHighestVulnerabilitySeverity = getHighestVulnerabilitySeverity;
const severityOrder = {
    LOW: 1,
    MEDIUM: 2,
    MODERATE: 2,
    HIGH: 3,
    CRITICAL: 4,
    UNKNOWN: 5,
};
function getHighestVulnerabilitySeverity(parent, child) {
    const parentVulSeverity = parent.vulnerabilitySeverity?.toUpperCase();
    const childVulSeverity = child?.vulnerabilitySeverity?.toUpperCase();
    if (childVulSeverity === undefined) {
        return parentVulSeverity;
    }
    if (parentVulSeverity === undefined) {
        return childVulSeverity;
    }
    return severityOrder[parentVulSeverity] >= severityOrder[childVulSeverity]
        ? parentVulSeverity
        : childVulSeverity;
}
//# sourceMappingURL=utils.js.map