export declare const exposedConfigOptions: string[];
export declare const allowedFields: {
    baseBranch: string;
    body: string;
    categories: string;
    currentValue: string;
    currentVersion: string;
    currentVersionAgeInDays: string;
    currentVersionTimestamp: string;
    currentDigest: string;
    currentDigestShort: string;
    datasource: string;
    depName: string;
    depNameLinked: string;
    depNameSanitized: string;
    depType: string;
    depTypes: string;
    displayFrom: string;
    displayPending: string;
    displayTo: string;
    hasReleaseNotes: string;
    indentation: string;
    isGroup: string;
    isLockfileUpdate: string;
    isMajor: string;
    isMinor: string;
    isPatch: string;
    isPin: string;
    isPinDigest: string;
    isRollback: string;
    isReplacement: string;
    isRange: string;
    isSingleVersion: string;
    isVulnerabilityAlert: string;
    logJSON: string;
    manager: string;
    newDigest: string;
    newDigestShort: string;
    newMajor: string;
    newMinor: string;
    newPatch: string;
    newName: string;
    newValue: string;
    newVersion: string;
    newVersionAgeInDays: string;
    packageFile: string;
    packageFileDir: string;
    packageName: string;
    packageScope: string;
    parentDir: string;
    parentOrg: string;
    platform: string;
    prettyDepType: string;
    prettyNewMajor: string;
    prettyNewVersion: string;
    project: string;
    recreateClosed: string;
    references: string;
    releases: string;
    releaseNotes: string;
    releaseTimestamp: string;
    repository: string;
    semanticPrefix: string;
    sourceRepo: string;
    sourceRepoName: string;
    sourceRepoOrg: string;
    sourceRepoSlug: string;
    sourceUrl: string;
    topLevelOrg: string;
    updateType: string;
    upgrades: string;
    url: string;
    version: string;
    versioning: string;
    versions: string;
    vulnerabilitySeverity: string;
};
type CompileInput = Record<string, unknown>;
export declare function proxyCompileInput(input: CompileInput, warnVariables: Set<string>): CompileInput;
export declare function compile(template: string, input: CompileInput, filterFields?: boolean): string;
export declare function safeCompile(template: string, input: CompileInput, filterFields?: boolean): string;
export {};
