"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.streamToString = streamToString;
const node_stream_1 = require("node:stream");
async function streamToString(stream) {
    const readable = node_stream_1.Readable.from(stream);
    const chunks = [];
    const p = await new Promise((resolve, reject) => {
        readable.on('data', (chunk) => chunks.push(Buffer.from(chunk)));
        readable.on('end', () => resolve(Buffer.concat(chunks).toString('utf8')));
        readable.on('error', (err) => reject(err));
    });
    return p;
}
//# sourceMappingURL=streams.js.map