interface TimingStatsReport {
    count: number;
    avgMs: number;
    medianMs: number;
    maxMs: number;
    totalMs: number;
}
export declare function makeTimingReport(data: number[]): TimingStatsReport;
export declare class LookupStats {
    static write(datasource: string, duration: number): void;
    static wrap<T>(datasource: string, callback: () => Promise<T>): Promise<T>;
    static getReport(): Record<string, TimingStatsReport>;
    static report(): void;
}
export declare class PackageCacheStats {
    static writeSet(duration: number): void;
    static wrapSet<T>(callback: () => Promise<T>): Promise<T>;
    static writeGet(duration: number): void;
    static wrapGet<T>(callback: () => Promise<T>): Promise<T>;
    static getReport(): {
        get: TimingStatsReport;
        set: TimingStatsReport;
    };
    static report(): void;
}
export interface DatasourceCacheReport {
    long: {
        [datasource in string]: {
            [registryUrl in string]: {
                [packageName in string]: {
                    read?: 'hit' | 'miss';
                    write?: 'set' | 'skip';
                };
            };
        };
    };
    short: {
        [datasource in string]: {
            [registryUrl in string]: {
                hit: number;
                miss: number;
                set: number;
                skip: number;
            };
        };
    };
}
export declare class DatasourceCacheStats {
    private static getData;
    private static setData;
    static hit(datasource: string, registryUrl: string, packageName: string): void;
    static miss(datasource: string, registryUrl: string, packageName: string): void;
    static set(datasource: string, registryUrl: string, packageName: string): void;
    static skip(datasource: string, registryUrl: string, packageName: string): void;
    static getReport(): DatasourceCacheReport;
    static report(): void;
}
export interface HttpRequestStatsDataPoint {
    method: string;
    url: string;
    reqMs: number;
    queueMs: number;
    status: number;
}
interface HostStatsData {
    count: number;
    reqAvgMs: number;
    reqMedianMs: number;
    reqMaxMs: number;
    queueAvgMs: number;
    queueMedianMs: number;
    queueMaxMs: number;
}
type UrlHttpStat = Record<string, Record<string, Record<string, number>>>;
interface HttpStatsCollection {
    urls: UrlHttpStat;
    hosts: Record<string, HostStatsData>;
    requests: number;
    rawRequests: string[];
    hostRequests: Record<string, HttpRequestStatsDataPoint[]>;
}
export declare class HttpStats {
    static write(data: HttpRequestStatsDataPoint): void;
    static getDataPoints(): HttpRequestStatsDataPoint[];
    static getReport(): HttpStatsCollection;
    static report(): void;
}
interface HttpCacheHostStatsData {
    hit: number;
    miss: number;
    localHit?: number;
    localMiss?: number;
}
type HttpCacheStatsData = Record<string, HttpCacheHostStatsData>;
export declare class HttpCacheStats {
    static getData(): HttpCacheStatsData;
    static read(key: string): HttpCacheHostStatsData;
    static write(key: string, data: HttpCacheHostStatsData): void;
    static getBaseUrl(url: string): string | null;
    static incLocalHits(url: string): void;
    static incLocalMisses(url: string): void;
    static incRemoteHits(url: string): void;
    static incRemoteMisses(url: string): void;
    static report(): void;
}
type ObsoleteCacheStats = Record<string, {
    count: number;
}>;
export declare class ObsoleteCacheHitLogger {
    static getData(): ObsoleteCacheStats;
    static write(url: string): void;
    static report(): void;
}
interface AbandonedPackage {
    datasource: string;
    packageName: string;
    mostRecentTimestamp: string;
}
type AbandonedPackageReport = Record<string, Record<string, string>>;
export declare class AbandonedPackageStats {
    static getData(): AbandonedPackage[];
    private static setData;
    static write(datasource: string, packageName: string, mostRecentTimestamp: string): void;
    static getReport(): AbandonedPackageReport;
    static report(): void;
}
export {};
