"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.all = all;
exports.map = map;
const tslib_1 = require("tslib");
const p_all_1 = tslib_1.__importDefault(require("p-all"));
const p_map_1 = tslib_1.__importDefault(require("p-map"));
const logger_1 = require("../logger");
const external_host_error_1 = require("../types/errors/external-host-error");
function isExternalHostError(err) {
    return err instanceof external_host_error_1.ExternalHostError;
}
function handleMultipleErrors(errors) {
    const hostError = errors.find(isExternalHostError);
    if (hostError) {
        throw hostError;
    }
    if (errors.length === 1 ||
        new Set(errors.map(({ message }) => message)).size === 1) {
        const [error] = errors;
        throw error;
    }
    throw new AggregateError(errors);
}
function handleError(err) {
    if (!(err instanceof AggregateError)) {
        throw err;
    }
    logger_1.logger.debug({ err }, 'Aggregate error is thrown');
    handleMultipleErrors(err.errors);
}
async function all(tasks, options) {
    try {
        const res = await (0, p_all_1.default)(tasks, {
            concurrency: 5,
            stopOnError: false,
            ...options,
        });
        return res;
    }
    catch (err) {
        return handleError(err);
    }
}
async function map(input, mapper, options) {
    try {
        const res = await (0, p_map_1.default)(input, mapper, {
            concurrency: 5,
            stopOnError: false,
            ...options,
        });
        return res;
    }
    catch (err) {
        return handleError(err);
    }
}
//# sourceMappingURL=promises.js.map