"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RepositoriesMatcher = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const string_match_1 = require("../string-match");
const base_1 = require("./base");
class RepositoriesMatcher extends base_1.Matcher {
    matches({ repository }, { matchRepositories }) {
        if (is_1.default.undefined(matchRepositories)) {
            return null;
        }
        if (is_1.default.undefined(repository)) {
            return false;
        }
        return (0, string_match_1.matchRegexOrGlobList)(repository, matchRepositories);
    }
}
exports.RepositoriesMatcher = RepositoriesMatcher;
//# sourceMappingURL=repositories.js.map