"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MergeConfidenceMatcher = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const error_messages_1 = require("../../constants/error-messages");
const merge_confidence_1 = require("../merge-confidence");
const base_1 = require("./base");
class MergeConfidenceMatcher extends base_1.Matcher {
    matches({ mergeConfidenceLevel }, { matchConfidence }) {
        if (is_1.default.nullOrUndefined(matchConfidence)) {
            return null;
        }
        /*
         * Throw an error for unauthenticated use of the matchConfidence matcher.
         */
        if (is_1.default.undefined((0, merge_confidence_1.getApiToken)())) {
            const error = new Error(error_messages_1.MISSING_API_CREDENTIALS);
            error.validationSource = 'MatchConfidence Authenticator';
            error.validationError = 'Missing credentials';
            error.validationMessage =
                'The `matchConfidence` matcher in `packageRules` requires authentication. Please refer to the [documentation](https://docs.renovatebot.com/configuration-options/#matchconfidence) and add the required host rule.';
            throw error;
        }
        return (is_1.default.array(matchConfidence) &&
            is_1.default.nonEmptyString(mergeConfidenceLevel) &&
            matchConfidence.includes(mergeConfidenceLevel));
    }
}
exports.MergeConfidenceMatcher = MergeConfidenceMatcher;
//# sourceMappingURL=merge-confidence.js.map