"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonataMatcher = void 0;
const logger_1 = require("../../logger");
const jsonata_1 = require("../jsonata");
const base_1 = require("./base");
class JsonataMatcher extends base_1.Matcher {
    async matches(inputConfig, { matchJsonata }) {
        if (!matchJsonata) {
            return null;
        }
        for (const expressionStr of matchJsonata) {
            const expression = (0, jsonata_1.getExpression)(expressionStr);
            if (expression instanceof Error) {
                logger_1.logger.warn({ errorMessage: expression.message }, 'Invalid JSONata expression');
            }
            else {
                try {
                    const result = await expression.evaluate(inputConfig);
                    if (result) {
                        // Only one needs to match, so return early
                        return true;
                    }
                }
                catch (err) {
                    logger_1.logger.warn({ err }, 'Error evaluating JSONata expression');
                }
            }
        }
        // None matched, so return false
        return false;
    }
}
exports.JsonataMatcher = JsonataMatcher;
//# sourceMappingURL=jsonata.js.map