"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DepNameMatcher = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const string_match_1 = require("../string-match");
const base_1 = require("./base");
class DepNameMatcher extends base_1.Matcher {
    matches({ depName }, { matchDepNames }) {
        if (is_1.default.undefined(matchDepNames)) {
            return null;
        }
        if (is_1.default.undefined(depName)) {
            return false;
        }
        return (0, string_match_1.matchRegexOrGlobList)(depName, matchDepNames);
    }
}
exports.DepNameMatcher = DepNameMatcher;
//# sourceMappingURL=dep-names.js.map