"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CurrentVersionMatcher = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../logger");
const allVersioning = tslib_1.__importStar(require("../../modules/versioning"));
const string_match_1 = require("../string-match");
const base_1 = require("./base");
class CurrentVersionMatcher extends base_1.Matcher {
    matches({ versioning, lockedVersion, currentValue, currentVersion, }, { matchCurrentVersion }) {
        if (is_1.default.undefined(matchCurrentVersion)) {
            return null;
        }
        const isUnconstrainedValue = !!lockedVersion && is_1.default.nullOrUndefined(currentValue);
        const versioningApi = allVersioning.get(versioning);
        const matchCurrentVersionStr = matchCurrentVersion.toString();
        const matchCurrentVersionPred = (0, string_match_1.getRegexPredicate)(matchCurrentVersionStr);
        if (matchCurrentVersionPred) {
            const compareVersion = lockedVersion ?? currentVersion ?? currentValue;
            return (!is_1.default.nullOrUndefined(compareVersion) &&
                matchCurrentVersionPred(compareVersion));
        }
        if (versioningApi.isVersion(matchCurrentVersionStr)) {
            try {
                return (isUnconstrainedValue ||
                    !!(currentValue &&
                        versioningApi.isValid(currentValue) &&
                        versioningApi.matches(matchCurrentVersionStr, currentValue)));
            }
            catch {
                return false;
            }
        }
        const compareVersion = versioningApi.isVersion(currentValue)
            ? currentValue // it's a version so we can match against it
            : (lockedVersion ?? currentVersion); // need to match against this currentVersion, if available
        if (is_1.default.nullOrUndefined(compareVersion)) {
            return false;
        }
        if (versioningApi.isVersion(compareVersion)) {
            return versioningApi.matches(compareVersion, matchCurrentVersion);
        }
        logger_1.logger.debug({ matchCurrentVersionStr, currentValue }, 'Could not find a version to compare');
        return false;
    }
}
exports.CurrentVersionMatcher = CurrentVersionMatcher;
//# sourceMappingURL=current-version.js.map