"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CurrentValueMatcher = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const string_match_1 = require("../string-match");
const base_1 = require("./base");
class CurrentValueMatcher extends base_1.Matcher {
    matches({ currentValue }, { matchCurrentValue }) {
        if (is_1.default.undefined(matchCurrentValue)) {
            return null;
        }
        const matchCurrentValuePred = (0, string_match_1.getRegexOrGlobPredicate)(matchCurrentValue);
        if (!currentValue) {
            return false;
        }
        return matchCurrentValuePred(currentValue);
    }
}
exports.CurrentValueMatcher = CurrentValueMatcher;
//# sourceMappingURL=current-value.js.map