"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CurrentAgeMatcher = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const pretty_time_1 = require("../pretty-time");
const base_1 = require("./base");
class CurrentAgeMatcher extends base_1.Matcher {
    matches({ currentVersionTimestamp }, { matchCurrentAge }) {
        if (!is_1.default.string(matchCurrentAge)) {
            return null;
        }
        if (!is_1.default.string(currentVersionTimestamp)) {
            return false;
        }
        return (0, pretty_time_1.satisfiesDateRange)(currentVersionTimestamp, matchCurrentAge);
    }
}
exports.CurrentAgeMatcher = CurrentAgeMatcher;
//# sourceMappingURL=current-age.js.map