"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseBranchesMatcher = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const string_match_1 = require("../string-match");
const base_1 = require("./base");
class BaseBranchesMatcher extends base_1.Matcher {
    matches({ baseBranch }, { matchBaseBranches }) {
        if (is_1.default.undefined(matchBaseBranches)) {
            return null;
        }
        if (is_1.default.undefined(baseBranch)) {
            return false;
        }
        return (0, string_match_1.matchRegexOrGlobList)(baseBranch, matchBaseBranches);
    }
}
exports.BaseBranchesMatcher = BaseBranchesMatcher;
//# sourceMappingURL=base-branches.js.map