/**
 * This is a workaround helper to allow the usage of 'unknown' in
 * a type-guard function while checking that keys exist.
 *
 * @see https://github.com/microsoft/TypeScript/issues/21732
 * @see https://stackoverflow.com/a/58630274
 */
export declare function hasKey<K extends string, T>(k: K, o: T): o is T & Record<K, unknown>;
/**
 * Coerce a value to a object with optional default value.
 * @param val value to coerce
 * @returns the coerced value.
 */
export declare function coerceObject<T>(val: T | null | undefined, def?: T): T;
