"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.coerceNumber = coerceNumber;
exports.parseInteger = parseInteger;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
/**
 * Coerces a value to a number with optional default value.
 * @param val the value to coerce
 * @param def default value
 * @returns cocerced value
 */
function coerceNumber(val, def) {
    return val ?? def ?? 0;
}
/**
 * Parses a value as a finite positive integer with optional default value.
 * If no default value is provided, the default value is 0.
 * @param val Value to parse as finite integer.
 * @param def Optional default value.
 * @returns The parsed value or the default value if the parsed value is not finite.
 */
function parseInteger(val, def) {
    // Number.parseInt returns NaN if the value is not a finite integer.
    const parsed = is_1.default.string(val) && /^\d+$/.test(val) ? Number.parseInt(val, 10) : Number.NaN;
    return Number.isFinite(parsed) ? parsed : (def ?? 0);
}
//# sourceMappingURL=number.js.map