/**
 * Coerces a value to a number with optional default value.
 * @param val the value to coerce
 * @param def default value
 * @returns cocerced value
 */
export declare function coerceNumber(val: number | null | undefined, def?: number): number;
/**
 * Parses a value as a finite positive integer with optional default value.
 * If no default value is provided, the default value is 0.
 * @param val Value to parse as finite integer.
 * @param def Optional default value.
 * @returns The parsed value or the default value if the parsed value is not finite.
 */
export declare function parseInteger(val: string | undefined | null, def?: number): number;
