"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMutex = getMutex;
exports.acquireLock = acquireLock;
const async_mutex_1 = require("async-mutex");
const DEFAULT_NAMESPACE = 'default';
const mutexes = {};
function getMutex(key, namespace = DEFAULT_NAMESPACE) {
    mutexes[namespace] ??= {};
    // create a new mutex if it doesn't exist with a timeout of 2 minutes
    mutexes[namespace][key] ??= (0, async_mutex_1.withTimeout)(new async_mutex_1.Mutex(), 1000 * 60 * 2);
    return mutexes[namespace][key];
}
function acquireLock(key, namespace = DEFAULT_NAMESPACE) {
    return getMutex(key, namespace).acquire();
}
//# sourceMappingURL=mutex.js.map