"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.minimatch = minimatch;
exports.minimatchFilter = minimatchFilter;
const minimatch_1 = require("minimatch");
const cache = new Map();
function minimatch(pattern, options, useCache = true) {
    const key = options ? `${pattern}:${JSON.stringify(options)}` : pattern;
    if (useCache) {
        const cachedResult = cache.get(key);
        if (cachedResult) {
            return cachedResult;
        }
    }
    const instance = new minimatch_1.Minimatch(pattern, options);
    if (useCache) {
        cache.set(key, instance);
    }
    return instance;
}
function minimatchFilter(pattern, options, useCache = true) {
    const key = options ? `${pattern}:${JSON.stringify(options)}` : pattern;
    if (useCache) {
        const cachedResult = cache.get(key);
        if (cachedResult) {
            return (fileName) => cachedResult.match(fileName);
        }
    }
    const instance = new minimatch_1.Minimatch(pattern, options);
    if (useCache) {
        cache.set(key, instance);
    }
    return (fileName) => instance.match(fileName);
}
//# sourceMappingURL=minimatch.js.map