"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EditorConfig = void 0;
const tslib_1 = require("tslib");
const editorconfig_1 = require("editorconfig");
const upath_1 = tslib_1.__importDefault(require("upath"));
const global_1 = require("../../config/global");
const logger_1 = require("../../logger");
class EditorConfig {
    static async getCodeFormat(fileName) {
        const localDir = global_1.GlobalConfig.get('localDir', '');
        try {
            const knownProps = await (0, editorconfig_1.parse)(upath_1.default.join(localDir, fileName));
            return {
                indentationSize: EditorConfig.getIndentationSize(knownProps),
                indentationType: EditorConfig.getIndentationType(knownProps),
                maxLineLength: knownProps.max_line_length,
            };
        }
        catch (err) {
            logger_1.logger.warn({ err }, 'Failed to parse editor config');
            return {};
        }
    }
    static getIndentationType(knownProps) {
        const { indent_style: indentStyle } = knownProps;
        if (indentStyle === 'tab') {
            return 'tab';
        }
        if (indentStyle === 'space') {
            return 'space';
        }
        return undefined;
    }
    static getIndentationSize(knownProps) {
        const indentSize = Number(knownProps.indent_size);
        if (!Number.isNaN(indentSize) && Number.isInteger(indentSize)) {
            return indentSize;
        }
        return undefined;
    }
}
exports.EditorConfig = EditorConfig;
//# sourceMappingURL=editor-config.js.map