"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getQueue = getQueue;
exports.clear = clear;
const tslib_1 = require("tslib");
const p_queue_1 = tslib_1.__importDefault(require("p-queue"));
const logger_1 = require("../../logger");
const url_1 = require("../url");
const rate_limits_1 = require("./rate-limits");
const hostQueues = new Map();
function getQueue(url) {
    const host = (0, url_1.parseUrl)(url)?.host;
    if (!host) {
        // should never happen
        logger_1.logger.debug(`No host on ${url}`);
        return null;
    }
    let queue = hostQueues.get(host);
    if (queue === undefined) {
        queue = null; // null represents "no queue", as opposed to undefined
        const concurrency = (0, rate_limits_1.getConcurrentRequestsLimit)(url);
        if (concurrency) {
            logger_1.logger.debug(`Using queue: host=${host}, concurrency=${concurrency}`);
            queue = new p_queue_1.default({ concurrency });
        }
        else {
            logger_1.logger.trace({ host }, 'No concurrency limits');
        }
    }
    hostQueues.set(host, queue);
    return queue;
}
function clear() {
    hostQueues.clear();
}
//# sourceMappingURL=queue.js.map