"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hooks = void 0;
exports.isResponseOk = isResponseOk;
exports.hook = hook;
function isResponseOk(response) {
    const { statusCode } = response;
    const limitStatusCode = response.request.options.followRedirect ? 299 : 399;
    return ((statusCode >= 200 && statusCode <= limitStatusCode) || statusCode === 304);
}
function hook(response) {
    if (isResponseOk(response)) {
        response.request.destroy();
    }
    return response;
}
exports.hooks = {
    afterResponse: [hook],
};
//# sourceMappingURL=hooks.js.map