"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GerritHttp = void 0;
exports.setBaseUrl = setBaseUrl;
const common_1 = require("../common");
const regex_1 = require("../regex");
const url_1 = require("../url");
const http_1 = require("./http");
let baseUrl;
function setBaseUrl(url) {
    baseUrl = url;
}
/**
 * Access Gerrit REST-API and strip-of the "magic prefix" from responses.
 * @see https://gerrit-review.googlesource.com/Documentation/rest-api.html
 */
class GerritHttp extends http_1.HttpBase {
    static magicPrefix = (0, regex_1.regEx)(/^\)]}'\n/g);
    get baseUrl() {
        return baseUrl;
    }
    constructor(options) {
        super('gerrit', options);
    }
    resolveUrl(requestUrl, options) {
        // ensure trailing slash for gerrit
        return super.resolveUrl((0, url_1.isHttpUrl)(requestUrl) ? requestUrl : `${baseUrl}${requestUrl}`, options);
    }
    processOptions(url, options) {
        options.parseJson = (text) => (0, common_1.parseJson)(text.replace(GerritHttp.magicPrefix, ''), url.pathname);
    }
}
exports.GerritHttp = GerritHttp;
//# sourceMappingURL=gerrit.js.map