import { z } from 'zod';
export declare const HttpCacheSchema: z.ZodCatch<z.ZodNullable<z.ZodObject<{
    etag: z.ZodOptional<z.ZodString>;
    lastModified: z.ZodOptional<z.ZodString>;
    httpResponse: z.ZodUnknown;
    timestamp: z.ZodString;
}, "strip", z.ZodTypeAny, {
    timestamp: string;
    etag?: string | undefined;
    lastModified?: string | undefined;
    httpResponse?: unknown;
}, {
    timestamp: string;
    etag?: string | undefined;
    lastModified?: string | undefined;
    httpResponse?: unknown;
}>>>;
export type HttpCache = z.infer<typeof HttpCacheSchema>;
