import type { PackageCacheNamespace } from '../../cache/package/types';
import type { HttpResponse } from '../types';
import { AbstractHttpCacheProvider } from './abstract-http-cache-provider';
import type { HttpCache } from './schema';
export interface PackageHttpCacheProviderOptions {
    namespace: PackageCacheNamespace;
    softTtlMinutes?: number;
    checkCacheControlHeader: boolean;
    checkAuthorizationHeader: boolean;
}
export declare class PackageHttpCacheProvider extends AbstractHttpCacheProvider {
    private namespace;
    private softTtlMinutes;
    private hardTtlMinutes;
    checkCacheControlHeader: boolean;
    checkAuthorizationHeader: boolean;
    constructor({ namespace, softTtlMinutes, checkCacheControlHeader, checkAuthorizationHeader, }: PackageHttpCacheProviderOptions);
    load(url: string): Promise<unknown>;
    persist(url: string, data: HttpCache): Promise<void>;
    bypassServer<T>(url: string, ignoreSoftTtl?: boolean): Promise<HttpResponse<T> | null>;
    cacheAllowed<T>(resp: HttpResponse<T>): boolean;
    wrapServerResponse<T>(url: string, resp: HttpResponse<T>): Promise<HttpResponse<T>>;
}
