"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.memCacheProvider = exports.MemoryHttpCacheProvider = void 0;
const tslib_1 = require("tslib");
const memCache = tslib_1.__importStar(require("../../cache/memory"));
const clone_1 = require("../../clone");
const abstract_http_cache_provider_1 = require("./abstract-http-cache-provider");
class MemoryHttpCacheProvider extends abstract_http_cache_provider_1.AbstractHttpCacheProvider {
    cacheKey(url) {
        return `memory-cache-http-provider:${url}`;
    }
    load(url) {
        const data = memCache.get(this.cacheKey(url));
        const cloned = (0, clone_1.clone)(data); // Ensures cached responses cannot be mutated
        return Promise.resolve(cloned);
    }
    persist(url, data) {
        memCache.set(this.cacheKey(url), data);
        return Promise.resolve();
    }
    async bypassServer(url) {
        const cached = await this.get(url);
        if (!cached) {
            return null;
        }
        return cached.httpResponse;
    }
}
exports.MemoryHttpCacheProvider = MemoryHttpCacheProvider;
exports.memCacheProvider = new MemoryHttpCacheProvider();
//# sourceMappingURL=memory-http-cache-provider.js.map