import { HttpBase, type InternalJsonUnsafeOptions } from './http';
import type { HttpMethod, HttpOptions, HttpResponse } from './types';
export declare function setBaseUrl(url: string): void;
export interface BitbucketHttpOptions extends HttpOptions {
    paginate?: boolean;
    pagelen?: number;
}
export declare class BitbucketHttp extends HttpBase<BitbucketHttpOptions> {
    protected get baseUrl(): string | undefined;
    constructor(type?: string, options?: BitbucketHttpOptions);
    protected requestJsonUnsafe<T>(method: HttpMethod, options: InternalJsonUnsafeOptions<BitbucketHttpOptions>): Promise<HttpResponse<T>>;
}
