import { HttpBase, type InternalJsonUnsafeOptions } from './http';
import type { HttpMethod, HttpOptions, HttpResponse } from './types';
export declare const setBaseUrl: (url: string) => void;
export interface BitbucketServerHttpOptions extends HttpOptions {
    paginate?: boolean;
    limit?: number;
    maxPages?: number;
}
export declare class BitbucketServerHttp extends HttpBase<BitbucketServerHttpOptions> {
    protected get baseUrl(): string | undefined;
    constructor(type?: string, options?: BitbucketServerHttpOptions);
    protected requestJsonUnsafe<T>(method: HttpMethod, options: InternalJsonUnsafeOptions<BitbucketServerHttpOptions>): Promise<HttpResponse<T>>;
}
