import type { CombinedHostRule, HostRule } from '../types';
export interface LegacyHostRule {
    hostName?: string;
    domainName?: string;
    baseUrl?: string;
    host?: string;
    endpoint?: string;
}
export declare function migrateRule(rule: LegacyHostRule & HostRule): HostRule;
export declare function add(params: HostRule): void;
export interface HostRuleSearch {
    hostType?: string;
    url?: string;
    readOnly?: boolean;
}
export declare function matchesHost(url: string, matchHost: string): boolean;
export declare function find(search: HostRuleSearch): CombinedHostRule;
export declare function hosts({ hostType }: {
    hostType: string;
}): string[];
export declare function hostType({ url }: {
    url: string;
}): string | null;
export declare function findAll({ hostType }: {
    hostType: string;
}): HostRule[];
/**
 * @returns a deep copy of all known host rules without any filtering
 */
export declare function getAll(): HostRule[];
export declare function clear(): void;
