"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hash = hash;
exports.toSha256 = toSha256;
exports.hashStream = hashStream;
const tslib_1 = require("tslib");
const crypto_1 = tslib_1.__importDefault(require("crypto"));
const promises_1 = require("stream/promises");
function hash(data, algorithm = 'sha512') {
    const hash = crypto_1.default.createHash(algorithm);
    hash.update(data);
    return hash.digest('hex');
}
function toSha256(input) {
    return hash(input, 'sha256');
}
async function hashStream(inputStream, algorithm = 'sha512') {
    const hash = crypto_1.default.createHash(algorithm);
    await (0, promises_1.pipeline)(inputStream, hash);
    return hash.digest('hex');
}
//# sourceMappingURL=hash.js.map