import type { LiteralUnion } from 'type-fest';
export type AlgorithmName = LiteralUnion<'sha1' | 'sha224' | 'sha256' | 'sha384' | 'sha512', string>;
export declare function hash(data: string | Buffer, algorithm?: AlgorithmName): string;
export declare function toSha256(input: string): string;
export declare function hashStream(inputStream: NodeJS.ReadableStream, algorithm?: AlgorithmName): Promise<string>;
