"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSourceUrlBase = getSourceUrlBase;
exports.getApiBaseUrl = getApiBaseUrl;
exports.getSourceUrl = getSourceUrl;
const url_1 = require("../url");
const defaultSourceUrlBase = 'https://github.com/';
const defaultApiBaseUrl = 'https://api.github.com/';
function getSourceUrlBase(registryUrl) {
    // default to GitHub.com if no GHE host is specified.
    return (0, url_1.ensureTrailingSlash)(registryUrl ?? defaultSourceUrlBase);
}
function getApiBaseUrl(registryUrl) {
    const sourceUrlBase = getSourceUrlBase(registryUrl);
    if (sourceUrlBase === defaultSourceUrlBase ||
        sourceUrlBase === defaultApiBaseUrl) {
        return defaultApiBaseUrl;
    }
    if (sourceUrlBase.endsWith('/api/v3/')) {
        return sourceUrlBase;
    }
    return `${sourceUrlBase}api/v3/`;
}
function getSourceUrl(packageName, registryUrl) {
    const sourceUrlBase = getSourceUrlBase(registryUrl);
    return `${sourceUrlBase}${packageName}`;
}
//# sourceMappingURL=url.js.map