"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findCommitOfTag = findCommitOfTag;
const logger_1 = require("../../logger");
const graphql_1 = require("./graphql");
async function findCommitOfTag(registryUrl, packageName, tag, http) {
    logger_1.logger.trace(`github/tags.findCommitOfTag(${packageName}, ${tag})`);
    try {
        const tags = await (0, graphql_1.queryTags)({ packageName, registryUrl }, http);
        if (!tags.length) {
            logger_1.logger.debug(`github/tags.findCommitOfTag(): No tags found for ${packageName}`);
        }
        const tagItem = tags.find(({ version }) => version === tag);
        if (tagItem) {
            if (tagItem.hash) {
                return tagItem.hash;
            }
            logger_1.logger.debug(`github/tags.findCommitOfTag: Tag ${tag} has no hash for ${packageName}`);
        }
        else {
            logger_1.logger.debug(`github/tags.findCommitOfTag: Tag ${tag} not found for ${packageName}`);
        }
    }
    catch (err) {
        logger_1.logger.debug({ githubRepo: packageName, err }, 'Error getting tag commit from GitHub repo');
    }
    return null;
}
//# sourceMappingURL=tags.js.map