"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubGraphqlMemoryCacheStrategy = void 0;
const tslib_1 = require("tslib");
const memCache = tslib_1.__importStar(require("../../../cache/memory"));
const abstract_cache_strategy_1 = require("./abstract-cache-strategy");
/**
 * In-memory strategy meant to be used for private packages
 * and for testing purposes.
 */
class GithubGraphqlMemoryCacheStrategy extends abstract_cache_strategy_1.AbstractGithubGraphqlCacheStrategy {
    fullKey() {
        return `github-graphql-cache:${this.cacheNs}:${this.cacheKey}`;
    }
    load() {
        const key = this.fullKey();
        const res = memCache.get(key);
        return Promise.resolve(res);
    }
    persist(cacheRecord) {
        const key = this.fullKey();
        memCache.set(key, cacheRecord);
        return Promise.resolve();
    }
}
exports.GithubGraphqlMemoryCacheStrategy = GithubGraphqlMemoryCacheStrategy;
//# sourceMappingURL=memory-cache-strategy.js.map