import type { GithubDatasourceItem, GithubGraphqlCacheRecord } from '../types';
import { AbstractGithubGraphqlCacheStrategy } from './abstract-cache-strategy';
/**
 * In-memory strategy meant to be used for private packages
 * and for testing purposes.
 */
export declare class GithubGraphqlMemoryCacheStrategy<GithubItem extends GithubDatasourceItem> extends AbstractGithubGraphqlCacheStrategy<GithubItem> {
    private fullKey;
    load(): Promise<GithubGraphqlCacheRecord<GithubItem> | undefined>;
    persist(cacheRecord: GithubGraphqlCacheRecord<GithubItem>): Promise<void>;
}
