"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setBranchNewCommit = setBranchNewCommit;
const logger_1 = require("../../logger");
const repository_1 = require("../cache/repository");
const _1 = require(".");
/**
 * Called when a new commit is added to branch
 *
 * ie. when branch is created/updated
 */
function setBranchNewCommit(branchName, baseBranch, commitSha) {
    logger_1.logger.debug('setBranchCommit()');
    const cache = (0, repository_1.getCache)();
    cache.branches ??= [];
    let branch = cache.branches.find((br) => br.branchName === branchName);
    if (!branch) {
        logger_1.logger.debug(`setBranchCommit(): Branch cache not present`); // should never be called
        branch = {
            branchName,
            baseBranch,
        };
        cache.branches.push(branch);
    }
    const baseBranchSha = (0, _1.getBranchCommit)(baseBranch);
    branch.baseBranchSha = baseBranchSha;
    branch.isBehindBase = false;
    branch.isConflicted = false;
    branch.isModified = false;
    branch.pristine = true;
    branch.sha = commitSha;
}
//# sourceMappingURL=set-branch-commit.js.map