"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.detectSemanticCommits = detectSemanticCommits;
const tslib_1 = require("tslib");
const conventional_commits_detector_1 = tslib_1.__importDefault(require("conventional-commits-detector"));
const logger_1 = require("../../logger");
const repository_1 = require("../../util/cache/repository");
const _1 = require(".");
async function detectSemanticCommits() {
    logger_1.logger.debug('detectSemanticCommits()');
    const cache = (0, repository_1.getCache)();
    if (cache.semanticCommits) {
        logger_1.logger.debug(`semanticCommits: returning "${cache.semanticCommits}" from cache`);
        return cache.semanticCommits;
    }
    const commitMessages = await (0, _1.getCommitMessages)();
    logger_1.logger.trace(`commitMessages=${JSON.stringify(commitMessages)}`);
    const type = (0, conventional_commits_detector_1.default)(commitMessages);
    logger_1.logger.debug(`semanticCommits: detected "${type}"`);
    if (type === 'angular') {
        logger_1.logger.debug(`semanticCommits: enabled`);
        cache.semanticCommits = 'enabled';
    }
    else {
        logger_1.logger.debug(`semanticCommits: disabled`);
        cache.semanticCommits = 'disabled';
    }
    return cache.semanticCommits;
}
//# sourceMappingURL=semantic.js.map