"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCachedConflictResult = getCachedConflictResult;
exports.setCachedConflictResult = setCachedConflictResult;
const logger_1 = require("../../logger");
const repository_1 = require("../cache/repository");
function getCachedConflictResult(branchName, branchSha, baseBranch, baseBranchSha) {
    const cache = (0, repository_1.getCache)();
    const branch = cache?.branches?.find((br) => br.branchName === branchName);
    if (branch &&
        branch.baseBranch === baseBranch &&
        branch.baseBranchSha === baseBranchSha &&
        branch.sha === branchSha &&
        branch.isConflicted !== undefined) {
        return branch.isConflicted;
    }
    return null;
}
function setCachedConflictResult(branchName, isConflicted) {
    const cache = (0, repository_1.getCache)();
    const branch = cache?.branches?.find((br) => br.branchName === branchName);
    if (!branch) {
        logger_1.logger.debug(`setCachedConflictResult(): Branch cache not present`);
        return;
    }
    branch.isConflicted = isConflicted;
}
//# sourceMappingURL=conflicts-cache.js.map