"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCachedBehindBaseResult = getCachedBehindBaseResult;
exports.setCachedBehindBaseResult = setCachedBehindBaseResult;
const logger_1 = require("../../logger");
const repository_1 = require("../cache/repository");
function getCachedBehindBaseResult(branchName, branchSha, baseBranch, baseBranchSha) {
    const cache = (0, repository_1.getCache)();
    const branch = cache.branches?.find((branch) => branch.branchName === branchName);
    if (branch &&
        branch.sha === branchSha &&
        branch.baseBranch === baseBranch &&
        branch.baseBranchSha === baseBranchSha &&
        branch.isBehindBase !== undefined) {
        return branch.isBehindBase;
    }
    return null;
}
function setCachedBehindBaseResult(branchName, isBehindBase) {
    const cache = (0, repository_1.getCache)();
    const branch = cache.branches?.find((branch) => branch.branchName === branchName);
    if (!branch) {
        logger_1.logger.debug(`setCachedBehindBaseResult(): Branch cache not present`);
        return;
    }
    branch.isBehindBase = isBehindBase;
}
//# sourceMappingURL=behind-base-branch-cache.js.map