import stream from 'node:stream';
import fs from 'fs-extra';
export declare const pipeline: typeof stream.pipeline.__promisify__;
export declare function getParentDir(fileName: string): string;
export declare function getSiblingFileName(fileName: string, siblingName: string): string;
export declare function readLocalFile(fileName: string): Promise<Buffer | null>;
export declare function readLocalFile(fileName: string, encoding: 'utf8'): Promise<string | null>;
export declare function readLocalSymlink(fileName: string): Promise<string | null>;
export declare function writeLocalFile(fileName: string, fileContent: string | Buffer): Promise<void>;
export declare function deleteLocalFile(fileName: string): Promise<void>;
export declare function renameLocalFile(fromFile: string, toFile: string): Promise<void>;
export declare function ensureDir(dirName: string): Promise<void>;
export declare function ensureLocalDir(dirName: string): Promise<string>;
export declare function ensureCacheDir(name: string): Promise<string>;
/**
 * Return the path of the private cache directory. This directory is wiped
 * between repositories, so they can be used to store private registries' index
 * without risk of that information leaking to other repositories/users.
 */
export declare function privateCacheDir(): string;
export declare function localPathExists(pathName: string): Promise<boolean>;
/**
 * Validate local path without throwing.
 * @param path Path to check
 * @returns `true` if given `path` is a valid local path, otherwise `false`.
 */
export declare function isValidLocalPath(path: string): boolean;
/**
 * Tries to find `otherFileName` in the directory where
 * `existingFileNameWithPath` is, then in its parent directory, then in the
 * grandparent, until we reach the top-level directory. All paths
 * must be relative to `localDir`.
 */
export declare function findLocalSiblingOrParent(existingFileNameWithPath: string, otherFileName: string): Promise<string | null>;
/**
 * Get files by name from directory
 */
export declare function readLocalDirectory(path: string): Promise<string[]>;
export declare function createCacheWriteStream(path: string): fs.WriteStream;
export declare function createCacheReadStream(path: string): fs.ReadStream;
export declare function localPathIsFile(pathName: string): Promise<boolean>;
export declare function localPathIsSymbolicLink(pathName: string): Promise<boolean>;
/**
 * Find a file or directory by walking up parent directories within localDir
 */
export declare function findUpLocal(fileName: string | string[], cwd: string): Promise<string | null>;
export declare function chmodLocalFile(fileName: string, mode: string | number): Promise<void>;
export declare function statLocalFile(fileName: string): Promise<fs.Stats | null>;
export declare function statCacheFile(pathName: string): Promise<fs.Stats | null>;
export declare function listCacheDir(path: string, options?: {
    recursive: boolean;
}): Promise<string[]>;
export declare function rmCache(path: string): Promise<void>;
export declare function cachePathExists(pathName: string): Promise<boolean>;
export declare function cachePathIsFile(pathName: string): Promise<boolean>;
export declare function readCacheFile(fileName: string): Promise<Buffer>;
export declare function readCacheFile(fileName: string, encoding: 'utf8'): Promise<string>;
export declare function outputCacheFile(file: string, data: string | NodeJS.ArrayBufferView): Promise<void>;
export declare function readSystemFile(fileName: string): Promise<Buffer>;
export declare function readSystemFile(fileName: string, encoding: 'utf8'): Promise<string>;
export declare function writeSystemFile(fileName: string, data: string | Buffer): Promise<void>;
export declare function getLocalFiles(fileNames: string[]): Promise<Record<string, string | null>>;
