"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getChildEnv = getChildEnv;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const env_1 = require("../env");
const env_2 = require("./env");
function getChildEnv({ extraEnv, env: forcedEnv = {}, } = {}) {
    const globalConfigEnv = (0, env_1.getCustomEnv)();
    const userConfiguredEnv = (0, env_1.getUserEnv)();
    const inheritedKeys = [];
    for (const [key, val] of Object.entries(extraEnv ?? {})) {
        if (is_1.default.string(val)) {
            inheritedKeys.push(key);
        }
    }
    const parentEnv = (0, env_2.getChildProcessEnv)(inheritedKeys);
    const combinedEnv = {
        ...extraEnv,
        ...parentEnv,
        ...globalConfigEnv,
        ...userConfiguredEnv,
        ...forcedEnv,
    };
    const result = {};
    for (const [key, val] of Object.entries(combinedEnv)) {
        if (is_1.default.string(val)) {
            result[key] = `${val}`;
        }
    }
    return result;
}
//# sourceMappingURL=utils.js.map