import type { JsonValue } from 'type-fest';
/**
 * Tries to detect the `platform` from a url.
 *
 * @param url the url to detect `platform` from
 * @returns matched `platform` if found, otherwise `null`
 */
export declare function detectPlatform(url: string): 'azure' | 'bitbucket' | 'bitbucket-server' | 'gitea' | 'github' | 'gitlab' | null;
export declare function noLeadingAtSymbol(input: string): string;
export declare function parseJson(content: string | null, filename: string): JsonValue;
export declare function parseJsonWithFallback(content: string, context: string): JsonValue;
export declare function parseJsonc(content: string): JsonValue;
