"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resetCache = resetCache;
exports.setCache = setCache;
exports.getCache = getCache;
exports.saveCache = saveCache;
exports.isCacheModified = isCacheModified;
const global_1 = require("../../../config/global");
const logger_1 = require("../../../logger");
const null_1 = require("./impl/null");
// This will be overwritten with initRepoCache()
// Used primarily as a placeholder and for testing
let repoCache = new null_1.RepoCacheNull();
function resetCache() {
    setCache(new null_1.RepoCacheNull());
}
function setCache(cache) {
    repoCache = cache;
}
function getCache() {
    return repoCache.getData();
}
async function saveCache() {
    if (global_1.GlobalConfig.get('dryRun')) {
        logger_1.logger.info(`DRY-RUN: Would save repository cache.`);
    }
    else {
        await repoCache.save();
    }
}
function isCacheModified() {
    return repoCache.isModified();
}
//# sourceMappingURL=index.js.map