"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RepoCacheLocal = void 0;
const logger_1 = require("../../../../logger");
const fs_1 = require("../../../fs");
const common_1 = require("../common");
const base_1 = require("./base");
class RepoCacheLocal extends base_1.RepoCacheBase {
    constructor(repository, fingerprint) {
        super(repository, fingerprint);
    }
    async read() {
        const cacheFileName = this.getCacheFileName();
        try {
            // suppress debug logs with errors
            if (!(await (0, fs_1.cachePathExists)(cacheFileName))) {
                return null;
            }
            return await (0, fs_1.readCacheFile)(cacheFileName, 'utf8');
        }
        catch (err) {
            logger_1.logger.debug({ err, cacheFileName }, 'Repository local cache not found');
        }
        return null;
    }
    async write(data) {
        const cacheFileName = this.getCacheFileName();
        await (0, fs_1.outputCacheFile)(cacheFileName, JSON.stringify(data));
    }
    getCacheFileName() {
        return (0, common_1.getLocalCacheFileName)(this.platform, this.repository);
    }
}
exports.RepoCacheLocal = RepoCacheLocal;
//# sourceMappingURL=local.js.map