"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cleanupHttpCache = cleanupHttpCache;
const luxon_1 = require("luxon");
const global_1 = require("../../../config/global");
const logger_1 = require("../../../logger");
const schema_1 = require("../../http/cache/schema");
function cleanupHttpCache(cacheData) {
    const { httpCache } = cacheData;
    if (!httpCache) {
        logger_1.logger.trace('cleanupHttpCache: no http cache to clean up');
        return;
    }
    const ttlDays = global_1.GlobalConfig.get('httpCacheTtlDays', 90);
    if (ttlDays === 0) {
        logger_1.logger.trace('cleanupHttpCache: zero value received, removing the cache');
        delete cacheData.httpCache;
        return;
    }
    const now = luxon_1.DateTime.now();
    for (const [url, item] of Object.entries(httpCache)) {
        const parsed = schema_1.HttpCacheSchema.safeParse(item);
        if (parsed.success && parsed.data) {
            const item = parsed.data;
            const expiry = luxon_1.DateTime.fromISO(item.timestamp).plus({ days: ttlDays });
            if (expiry < now) {
                logger_1.logger.debug(`http cache: removing expired cache for ${url}`);
                delete httpCache[url];
            }
        }
    }
}
//# sourceMappingURL=http-cache.js.map