import type { PackageCacheNamespace } from './types';
export declare function getTtlOverride(namespace: PackageCacheNamespace): number | undefined;
export interface TTLValues {
    /** TTL for serving cached value without hitting the server */
    softTtlMinutes: number;
    /** TTL for serving stale cache when upstream responds with errors */
    hardTtlMinutes: number;
}
/**
 * Apply user-configured overrides and return the final values for soft/hard TTL.
 *
 * @param namespace Cache namespace
 * @param ttlMinutes TTL value configured in Renovate codebase
 * @returns
 */
export declare function resolveTtlValues(namespace: PackageCacheNamespace, ttlMinutes: number): TTLValues;
