"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.init = init;
exports.reset = reset;
exports.get = get;
exports.set = set;
exports.cleanDatasourceKeys = cleanDatasourceKeys;
let memCache;
function init() {
    memCache = {};
}
function reset() {
    memCache = undefined;
}
function get(key) {
    return memCache?.[key];
}
function set(key, value) {
    if (memCache) {
        memCache[key] = value;
    }
}
function cleanDatasourceKeys() {
    if (memCache) {
        for (const key of Object.keys(memCache)) {
            if (key.startsWith('datasource-mem:pkg-fetch:') ||
                key.startsWith('datasource-mem:releases:')) {
                delete memCache[key];
            }
        }
    }
}
//# sourceMappingURL=index.js.map