"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assignKeys = assignKeys;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
/**
 * Assigns non-nullish values from `right` to `left` for the given `keys`.
 */
function assignKeys(left, right, keys) {
    for (const key of keys) {
        const val = right[key];
        if (!is_1.default.nullOrUndefined(val)) {
            left[key] = val;
        }
    }
    return left;
}
//# sourceMappingURL=assign-keys.js.map