"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.coerceArray = coerceArray;
exports.isNotNullOrUndefined = isNotNullOrUndefined;
exports.toArray = toArray;
exports.deduplicateArray = deduplicateArray;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
function coerceArray(input) {
    if (is_1.default.array(input)) {
        return input;
    }
    return [];
}
// Useful for filtering an array so that it includes values that are not null or
// undefined. This predicate acts as a type guard so that the resulting type for
// `values.filter(isNotNullOrUndefined)` is `T[]`.
function isNotNullOrUndefined(value) {
    return !is_1.default.nullOrUndefined(value);
}
/**
 * Converts a single value or an array of values to an array of values.
 * @param value a single value or an array of values
 * @returns array of values
 */
function toArray(value) {
    return is_1.default.array(value) ? value : [value];
}
function deduplicateArray(array) {
    return Array.from(new Set(array));
}
//# sourceMappingURL=array.js.map